<?php

namespace App\Http\Controllers;

use App\Models\Sale;
use Illuminate\Http\Request;
use Carbon\Carbon;

class SaleController extends Controller
{
    public function index(Request $request)
    {
        $query = Sale::with('user', 'items');

        if ($request->has('date_from') && $request->has('date_to')) {
            $query->whereBetween('created_at', [
                Carbon::parse($request->date_from)->startOfDay(),
                Carbon::parse($request->date_to)->endOfDay()
            ]);
        }

        if ($request->has('payment_method')) {
            $query->where('payment_method', $request->payment_method);
        }

        $sales = $query->latest()->paginate(15);
        $totalSales = $query->sum('total_amount');

        return view('sales.index', compact('sales', 'totalSales'));
    }

    public function show(Sale $sale)
    {
        $sale->load('user', 'items.product');
        return view('sales.show', compact('sale'));
    }

    public function destroy(Sale $sale)
    {
        // استرجاع المنتجات للمخزون
        foreach ($sale->items as $item) {
            $product = $item->product;
            $product->quantity += $item->quantity;
            $product->save();
        }

        $sale->delete();

        return redirect()->route('sales.index')
            ->with('success', 'تم حذف عملية البيع بنجاح');
    }
}
