@extends('layouts.app')

@section('page-title', 'المشتريات')

@section('content')
    <div class="card">
        <div class="card-header bg-white d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="bi bi-bag-plus"></i> قائمة المشتريات</h5>
            <a href="{{ route('purchases.create') }}" class="btn btn-primary">
                <i class="bi bi-plus-circle"></i> إضافة فاتورة شراء
            </a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                    <tr>
                        <th>رقم الفاتورة</th>
                        <th>المورد</th>
                        <th>المستخدم</th>
                        <th>المبلغ الإجمالي</th>
                        <th>المدفوع</th>
                        <th>المتبقي</th>
                        <th>حالة الدفع</th>
                        <th>التاريخ</th>
                        <th>إجراءات</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($purchases as $purchase)
                        <tr>
                            <td><strong>{{ $purchase->invoice_number }}</strong></td>
                            <td>{{ $purchase->supplier->name }}</td>
                            <td>{{ $purchase->user->name }}</td>
                            <td>{{ number_format($purchase->total_amount, 2) }} ج.م</td>
                            <td>{{ number_format($purchase->paid_amount, 2) }} ج.م</td>
                            <td>{{ number_format($purchase->remainingAmount(), 2) }} ج.م</td>
                            <td>
                                @if($purchase->payment_status == 'paid')
                                    <span class="badge bg-success">مدفوع</span>
                                @elseif($purchase->payment_status == 'partial')
                                    <span class="badge bg-warning">جزئي</span>
                                @else
                                    <span class="badge bg-danger">غير مدفوع</span>
                                @endif
                            </td>
                            <td>{{ $purchase->created_at->format('Y-m-d') }}</td>
                            <td>
                                <a href="{{ route('purchases.show', $purchase) }}" class="btn btn-sm btn-info btn-action">
                                    <i class="bi bi-eye"></i>
                                </a>
                                @if(auth()->user()->isAdmin())
                                    <form action="{{ route('purchases.destroy', $purchase) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger btn-action"
                                                onclick="return confirm('هل أنت متأكد؟ سيتم استرجاع المنتجات من المخزون.')">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="text-center py-4">لا توجد مشتريات</td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>

            {{ $purchases->links() }}
        </div>
    </div>
@endsection`
