{{-- resources/views/reports/inventory.blade.php --}}
@extends('layouts.app')
@section('page-title', 'تقرير المخزون')

@section('content')
    <div class="card">
        <div class="card-header bg-white">
            <h5 class="mb-0"><i class="bi bi-box-seam"></i> تقرير المخزون</h5>
        </div>
        <div class="card-body">
            <div class="row g-3 mb-4">
                <div class="col-md-4">
                    <div class="stat-card primary">
                        <h6>قيمة المخزون الإجمالية</h6>
                        <h3>{{ number_format($totalValue, 2) }} ج.م</h3>
                        <small>سعر التكلفة</small>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-card success">
                        <h6>الربح المحتمل</h6>
                        <h3>{{ number_format($totalPotentialProfit, 2) }} ج.م</h3>
                        <small>عند بيع كل المخزون</small>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-card warning">
                        <h6>منتجات قليلة</h6>
                        <h3>{{ $lowStockCount }}</h3>
                        <small>تحتاج إعادة طلب</small>
                    </div>
                </div>
            </div>

            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                    <tr>
                        <th>المنتج</th>
                        <th>الفئة</th>
                        <th>الكمية</th>
                        <th>سعر التكلفة</th>
                        <th>سعر البيع</th>
                        <th>قيمة المخزون</th>
                        <th>الربح المحتمل</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($products as $product)
                        <tr class="{{ $product->quantity <= $product->min_quantity ? 'table-warning' : '' }}">
                            <td><strong>{{ $product->name }}</strong></td>
                            <td><span class="badge bg-info">{{ $product->category->name }}</span></td>
                            <td>
                                @if($product->quantity <= $product->min_quantity)
                                    <span class="badge bg-danger">{{ $product->quantity }}</span>
                                @else
                                    {{ $product->quantity }}
                                @endif
                            </td>
                            <td>{{ number_format($product->cost_price, 2) }} ج.م</td>
                            <td>{{ number_format($product->selling_price, 2) }} ج.م</td>
                            <td><strong>{{ number_format($product->inventory_value, 2) }} ج.م</strong></td>
                            <td class="text-success">{{ number_format($product->potential_profit, 2) }} ج.م</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center py-4">لا توجد منتجات</td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
