{{-- resources/views/reports/top-products.blade.php --}}
@extends('layouts.app')

@section('page-title', 'المنتجات الأكثر مبيعاً')

@section('content')
    <div class="card">
        <div class="card-header bg-white">
            <h5 class="mb-0"><i class="bi bi-star"></i> المنتجات الأكثر مبيعاً</h5>
        </div>
        <div class="card-body">
            <form method="GET" class="row g-3 mb-4">
                <div class="col-md-4">
                    <label class="form-label">من تاريخ</label>
                    <input type="date" name="date_from" class="form-control"
                           value="{{ request('date_from', \Carbon\Carbon::parse($dateFrom)->format('Y-m-d')) }}"
                    >
                </div>
                <div class="col-md-4">
                    <label class="form-label">إلى تاريخ</label>
                    <input type="date" name="date_to" class="form-control"
                           value="{{ request('date_to', \Carbon\Carbon::parse($dateTo)->format('Y-m-d')) }}"

                    >
                </div>
                <div class="col-md-4">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="bi bi-search"></i> عرض التقرير
                    </button>
                </div>
            </form>

            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>المنتج</th>
                        <th>الفئة</th>
                        <th>الكمية المباعة</th>
                        <th>عدد المرات</th>
                        <th>الإيرادات</th>
                        <th>متوسط السعر</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($products as $index => $product)
                        <tr>
                            <td>
                                @if($index < 3)
                                    <span class="badge bg-warning fs-6">🏆 {{ $index + 1 }}</span>
                                @else
                                    {{ $index + 1 }}
                                @endif
                            </td>
                            <td><strong>{{ $product->name }}</strong></td>
                            <td><span class="badge bg-info">{{ $product->category->name }}</span></td>
                            <td><span class="badge bg-primary">{{ $product->total_quantity }}</span></td>
                            <td>{{ $product->times_sold }} مرة</td>
                            <td><strong>{{ number_format($product->total_revenue, 2) }} ج.م</strong></td>
                            <td>{{ number_format($product->total_revenue / $product->total_quantity, 2) }} ج.م</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center py-4">لا توجد مبيعات في هذه الفترة</td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>

            @if($products->count() > 0)
                <div class="row mt-4">
                    <div class="col-md-6">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h6><i class="bi bi-trophy-fill text-warning"></i> المنتج الأكثر مبيعاً</h6>
                                <h4>{{ $products->first()->name }}</h4>
                                <p class="mb-0">
                                    <strong>{{ $products->first()->total_quantity }}</strong> وحدة بإيرادات
                                    <strong>{{ number_format($products->first()->total_revenue, 2) }} ج.م</strong>
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h6><i class="bi bi-graph-up text-success"></i> إجمالي الإحصائيات</h6>
                                <p class="mb-1"><strong>إجمالي الكميات:</strong> {{ $products->sum('total_quantity') }} وحدة</p>
                                <p class="mb-0"><strong>إجمالي الإيرادات:</strong> {{ number_format($products->sum('total_revenue'), 2) }} ج.م</p>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
@endsection
