@extends('layouts.app')

@section('page-title', 'المبيعات')

@section('content')
    <div class="card">
        <div class="card-header bg-white">
            <h5 class="mb-0"><i class="bi bi-receipt"></i> قائمة المبيعات</h5>
        </div>
        <div class="card-body">
            <form method="GET" class="row g-3 mb-4">
                <div class="col-md-3">
                    <input type="date" name="date_from" class="form-control" placeholder="من تاريخ"
                           value="{{ request('date_from') }}">
                </div>
                <div class="col-md-3">
                    <input type="date" name="date_to" class="form-control" placeholder="إلى تاريخ"
                           value="{{ request('date_to') }}">
                </div>
                <div class="col-md-3">
                    <select name="payment_method" class="form-select">
                        <option value="">كل طرق الدفع</option>
                        <option value="cash" {{ request('payment_method') == 'cash' ? 'selected' : '' }}>نقدي</option>
                        <option value="card" {{ request('payment_method') == 'card' ? 'selected' : '' }}>بطاقة</option>
                        <option value="mobile_wallet" {{ request('payment_method') == 'mobile_wallet' ? 'selected' : '' }}>محفظة إلكترونية</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="bi bi-search"></i> بحث
                    </button>
                </div>
            </form>

            @if(isset($totalSales))
                <div class="alert alert-info">
                    <strong>إجمالي المبيعات:</strong> {{ number_format($totalSales, 2) }} ج.م
                </div>
            @endif

            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                    <tr>
                        <th>رقم الفاتورة</th>
                        <th>الكاشير</th>
                        <th>المبلغ الفرعي</th>
                        <th>الخصم</th>
                        <th>الإجمالي</th>
                        <th>طريقة الدفع</th>
                        <th>التاريخ</th>
                        <th>إجراءات</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($sales as $sale)
                        <tr>
                            <td><strong>{{ $sale->invoice_number }}</strong></td>
                            <td>{{ $sale->user->name }}</td>
                            <td>{{ number_format($sale->subtotal, 2) }} ج.م</td>
                            <td>{{ number_format($sale->discount, 2) }} ج.م</td>
                            <td><strong>{{ number_format($sale->total_amount, 2) }} ج.م</strong></td>
                            <td>
                                @if($sale->payment_method == 'cash')
                                    <span class="badge bg-success">نقدي</span>
                                @elseif($sale->payment_method == 'card')
                                    <span class="badge bg-primary">بطاقة</span>
                                @else
                                    <span class="badge bg-info">محفظة إلكترونية</span>
                                @endif
                            </td>
                            <td>{{ $sale->created_at->format('Y-m-d H:i') }}</td>
                            <td>
                                <a href="{{ route('sales.show', $sale) }}" class="btn btn-sm btn-info btn-action">
                                    <i class="bi bi-eye"></i>
                                </a>
                                <a href="{{ route('pos.receipt', $sale) }}" class="btn btn-sm btn-primary btn-action" target="_blank">
                                    <i class="bi bi-printer"></i>
                                </a>
                                @if(auth()->user()->isAdmin())
                                    <form action="{{ route('sales.destroy', $sale) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger btn-action"
                                                onclick="return confirm('هل أنت متأكد من حذف هذه الفاتورة؟')">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center py-4">لا توجد مبيعات</td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>

            {{ $sales->links() }}
        </div>
    </div>
@endsection
