<?php $__env->startSection('page-title', 'المبيعات'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header bg-white">
            <h5 class="mb-0"><i class="bi bi-receipt"></i> قائمة المبيعات</h5>
        </div>
        <div class="card-body">
            <form method="GET" class="row g-3 mb-4">
                <div class="col-md-3">
                    <input type="date" name="date_from" class="form-control" placeholder="من تاريخ"
                           value="<?php echo e(request('date_from')); ?>">
                </div>
                <div class="col-md-3">
                    <input type="date" name="date_to" class="form-control" placeholder="إلى تاريخ"
                           value="<?php echo e(request('date_to')); ?>">
                </div>
                <div class="col-md-3">
                    <select name="payment_method" class="form-select">
                        <option value="">كل طرق الدفع</option>
                        <option value="cash" <?php echo e(request('payment_method') == 'cash' ? 'selected' : ''); ?>>نقدي</option>
                        <option value="card" <?php echo e(request('payment_method') == 'card' ? 'selected' : ''); ?>>بطاقة</option>
                        <option value="mobile_wallet" <?php echo e(request('payment_method') == 'mobile_wallet' ? 'selected' : ''); ?>>محفظة إلكترونية</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="bi bi-search"></i> بحث
                    </button>
                </div>
            </form>

            <?php if(isset($totalSales)): ?>
                <div class="alert alert-info">
                    <strong>إجمالي المبيعات:</strong> <?php echo e(number_format($totalSales, 2)); ?> ج.م
                </div>
            <?php endif; ?>

            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                    <tr>
                        <th>رقم الفاتورة</th>
                        <th>الكاشير</th>
                        <th>المبلغ الفرعي</th>
                        <th>الخصم</th>
                        <th>الإجمالي</th>
                        <th>طريقة الدفع</th>
                        <th>التاريخ</th>
                        <th>إجراءات</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><strong><?php echo e($sale->invoice_number); ?></strong></td>
                            <td><?php echo e($sale->user->name); ?></td>
                            <td><?php echo e(number_format($sale->subtotal, 2)); ?> ج.م</td>
                            <td><?php echo e(number_format($sale->discount, 2)); ?> ج.م</td>
                            <td><strong><?php echo e(number_format($sale->total_amount, 2)); ?> ج.م</strong></td>
                            <td>
                                <?php if($sale->payment_method == 'cash'): ?>
                                    <span class="badge bg-success">نقدي</span>
                                <?php elseif($sale->payment_method == 'card'): ?>
                                    <span class="badge bg-primary">بطاقة</span>
                                <?php else: ?>
                                    <span class="badge bg-info">محفظة إلكترونية</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($sale->created_at->format('Y-m-d H:i')); ?></td>
                            <td>
                                <a href="<?php echo e(route('sales.show', $sale)); ?>" class="btn btn-sm btn-info btn-action">
                                    <i class="bi bi-eye"></i>
                                </a>
                                <a href="<?php echo e(route('pos.receipt', $sale)); ?>" class="btn btn-sm btn-primary btn-action" target="_blank">
                                    <i class="bi bi-printer"></i>
                                </a>
                                <?php if(auth()->user()->isAdmin()): ?>
                                    <form action="<?php echo e(route('sales.destroy', $sale)); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-danger btn-action"
                                                onclick="return confirm('هل أنت متأكد من حذف هذه الفاتورة؟')">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center py-4">لا توجد مبيعات</td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <?php echo e($sales->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\2025\supermarket-pos\resources\views/sales/index.blade.php ENDPATH**/ ?>