<?php $__env->startSection('page-title', 'المنتجات الأكثر مبيعاً'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header bg-white">
            <h5 class="mb-0"><i class="bi bi-star"></i> المنتجات الأكثر مبيعاً</h5>
        </div>
        <div class="card-body">
            <form method="GET" class="row g-3 mb-4">
                <div class="col-md-4">
                    <label class="form-label">من تاريخ</label>
                    <input type="date" name="date_from" class="form-control"
                           value="<?php echo e(request('date_from', $dateFrom->format('Y-m-d'))); ?>">
                </div>
                <div class="col-md-4">
                    <label class="form-label">إلى تاريخ</label>
                    <input type="date" name="date_to" class="form-control"
                           value="<?php echo e(request('date_to', $dateTo->format('Y-m-d'))); ?>">
                </div>
                <div class="col-md-4">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="bi bi-search"></i> عرض التقرير
                    </button>
                </div>
            </form>

            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>المنتج</th>
                        <th>الفئة</th>
                        <th>الكمية المباعة</th>
                        <th>عدد المرات</th>
                        <th>الإيرادات</th>
                        <th>متوسط السعر</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <?php if($index < 3): ?>
                                    <span class="badge bg-warning fs-6">🏆 <?php echo e($index + 1); ?></span>
                                <?php else: ?>
                                    <?php echo e($index + 1); ?>

                                <?php endif; ?>
                            </td>
                            <td><strong><?php echo e($product->name); ?></strong></td>
                            <td><span class="badge bg-info"><?php echo e($product->category->name); ?></span></td>
                            <td><span class="badge bg-primary"><?php echo e($product->total_quantity); ?></span></td>
                            <td><?php echo e($product->times_sold); ?> مرة</td>
                            <td><strong><?php echo e(number_format($product->total_revenue, 2)); ?> ج.م</strong></td>
                            <td><?php echo e(number_format($product->total_revenue / $product->total_quantity, 2)); ?> ج.م</td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center py-4">لا توجد مبيعات في هذه الفترة</td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <?php if($products->count() > 0): ?>
                <div class="row mt-4">
                    <div class="col-md-6">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h6><i class="bi bi-trophy-fill text-warning"></i> المنتج الأكثر مبيعاً</h6>
                                <h4><?php echo e($products->first()->name); ?></h4>
                                <p class="mb-0">
                                    <strong><?php echo e($products->first()->total_quantity); ?></strong> وحدة بإيرادات
                                    <strong><?php echo e(number_format($products->first()->total_revenue, 2)); ?> ج.م</strong>
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h6><i class="bi bi-graph-up text-success"></i> إجمالي الإحصائيات</h6>
                                <p class="mb-1"><strong>إجمالي الكميات:</strong> <?php echo e($products->sum('total_quantity')); ?> وحدة</p>
                                <p class="mb-0"><strong>إجمالي الإيرادات:</strong> <?php echo e(number_format($products->sum('total_revenue'), 2)); ?> ج.م</p>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\2025\supermarket-pos\resources\views/reports/top-products.blade.php ENDPATH**/ ?>