<?php $__env->startSection('page-title', 'المشتريات'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header bg-white d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="bi bi-bag-plus"></i> قائمة المشتريات</h5>
            <a href="<?php echo e(route('purchases.create')); ?>" class="btn btn-primary">
                <i class="bi bi-plus-circle"></i> إضافة فاتورة شراء
            </a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                    <tr>
                        <th>رقم الفاتورة</th>
                        <th>المورد</th>
                        <th>المستخدم</th>
                        <th>المبلغ الإجمالي</th>
                        <th>المدفوع</th>
                        <th>المتبقي</th>
                        <th>حالة الدفع</th>
                        <th>التاريخ</th>
                        <th>إجراءات</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><strong><?php echo e($purchase->invoice_number); ?></strong></td>
                            <td><?php echo e($purchase->supplier->name); ?></td>
                            <td><?php echo e($purchase->user->name); ?></td>
                            <td><?php echo e(number_format($purchase->total_amount, 2)); ?> ج.م</td>
                            <td><?php echo e(number_format($purchase->paid_amount, 2)); ?> ج.م</td>
                            <td><?php echo e(number_format($purchase->remainingAmount(), 2)); ?> ج.م</td>
                            <td>
                                <?php if($purchase->payment_status == 'paid'): ?>
                                    <span class="badge bg-success">مدفوع</span>
                                <?php elseif($purchase->payment_status == 'partial'): ?>
                                    <span class="badge bg-warning">جزئي</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">غير مدفوع</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($purchase->created_at->format('Y-m-d')); ?></td>
                            <td>
                                <a href="<?php echo e(route('purchases.show', $purchase)); ?>" class="btn btn-sm btn-info btn-action">
                                    <i class="bi bi-eye"></i>
                                </a>
                                <?php if(auth()->user()->isAdmin()): ?>
                                    <form action="<?php echo e(route('purchases.destroy', $purchase)); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-danger btn-action"
                                                onclick="return confirm('هل أنت متأكد؟ سيتم استرجاع المنتجات من المخزون.')">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9" class="text-center py-4">لا توجد مشتريات</td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <?php echo e($purchases->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\2026\supermarket-pos\resources\views/purchases/index.blade.php ENDPATH**/ ?>