<?php $__env->startSection('page-title', 'منتجات أوشكت على النفاذ'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card border-warning">
        <div class="card-header bg-warning text-dark d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="bi bi-exclamation-triangle"></i> منتجات أوشكت على النفاذ</h5>
            <a href="<?php echo e(route('products.index')); ?>" class="btn btn-dark btn-sm">
                <i class="bi bi-arrow-right"></i> رجوع للمنتجات
            </a>
        </div>
        <div class="card-body">
            <?php if($products->count() > 0): ?>
                <div class="alert alert-warning">
                    <i class="bi bi-exclamation-triangle"></i>
                    <strong>تحذير!</strong> يوجد <?php echo e($products->total()); ?> منتج أوشك على النفاذ ويحتاج إلى إعادة طلب.
                </div>

                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="table-light">
                        <tr>
                            <th>الصورة</th>
                            <th>اسم المنتج</th>
                            <th>الباركود</th>
                            <th>الفئة</th>
                            <th>الكمية الحالية</th>
                            <th>الحد الأدنى</th>
                            <th>الحالة</th>
                            <th>إجراءات</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="table-warning">
                                <td>
                                    <?php if($product->image): ?>
                                        <img src="<?php echo e(asset('storage/' . $product->image)); ?>" width="50" height="50" class="rounded">
                                    <?php else: ?>
                                        <div class="bg-light rounded" style="width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                            <i class="bi bi-box-seam"></i>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td><strong><?php echo e($product->name); ?></strong></td>
                                <td><?php echo e($product->barcode); ?></td>
                                <td><span class="badge bg-info"><?php echo e($product->category->name); ?></span></td>
                                <td>
                                    <span class="badge bg-danger fs-6"><?php echo e($product->quantity); ?></span>
                                </td>
                                <td><?php echo e($product->min_quantity); ?></td>
                                <td>
                                    <?php if($product->quantity == 0): ?>
                                        <span class="badge bg-danger">نفذ من المخزن</span>
                                    <?php else: ?>
                                        <span class="badge bg-warning text-dark">قليل جداً</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('products.show', $product)); ?>" class="btn btn-sm btn-info btn-action">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <a href="<?php echo e(route('products.edit', $product)); ?>" class="btn btn-sm btn-primary btn-action">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <a href="<?php echo e(route('purchases.create')); ?>" class="btn btn-sm btn-success btn-action">
                                        <i class="bi bi-cart-plus"></i> طلب
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <?php echo e($products->links()); ?>


            <?php else: ?>
                <div class="text-center py-5">
                    <i class="bi bi-check-circle text-success" style="font-size: 4rem;"></i>
                    <h4 class="mt-3 text-success">رائع! 🎉</h4>
                    <p class="text-muted">جميع المنتجات متوفرة بكميات كافية</p>
                    <a href="<?php echo e(route('products.index')); ?>" class="btn btn-primary mt-3">
                        <i class="bi bi-arrow-right"></i> العودة للمنتجات
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\2025\supermarket-pos\resources\views/products/low-stock.blade.php ENDPATH**/ ?>