<?php $__env->startSection('page-title', 'المنتجات'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header bg-white d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="bi bi-box-seam"></i> قائمة المنتجات</h5>
            <div>
                <a href="<?php echo e(route('products.low-stock')); ?>" class="btn btn-warning btn-sm me-2">
                    <i class="bi bi-exclamation-triangle"></i> منتجات أوشكت على النفاذ
                </a>
                <a href="<?php echo e(route('products.create')); ?>" class="btn btn-primary">
                    <i class="bi bi-plus-circle"></i> إضافة منتج جديد
                </a>
            </div>
        </div>
        <div class="card-body">
            <form method="GET" class="row g-3 mb-4">
                <div class="col-md-4">
                    <input type="text" name="search" class="form-control" placeholder="البحث بالاسم أو الباركود..."
                           value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-3">
                    <select name="category_id" class="form-select">
                        <option value="">كل الفئات</option>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($category->id); ?>" <?php echo e(request('category_id') == $category->id ? 'selected' : ''); ?>>
                                <?php echo e($category->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <div class="form-check mt-2">
                        <input class="form-check-input" type="checkbox" name="low_stock" id="lowStock"
                            <?php echo e(request('low_stock') ? 'checked' : ''); ?>>
                        <label class="form-check-label" for="lowStock">منتجات قليلة</label>
                    </div>
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="bi bi-search"></i> بحث
                    </button>
                </div>
            </form>

            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                    <tr>
                        <th>الصورة</th>
                        <th>الاسم</th>
                        <th>الباركود</th>
                        <th>الفئة</th>
                        <th>سعر الشراء</th>
                        <th>سعر البيع</th>
                        <th>الكمية</th>
                        <th>الصلاحية</th>
                        <th>إجراءات</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="<?php echo e($product->isLowStock() ? 'table-warning' : ''); ?>">
                            <td>
                                <?php if($product->image): ?>
                                    <img src="<?php echo e(asset('storage/' . $product->image)); ?>" width="50" height="50" class="rounded">
                                <?php else: ?>
                                    <div class="bg-light rounded" style="width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                        <i class="bi bi-box-seam"></i>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td><strong><?php echo e($product->name); ?></strong></td>
                            <td><?php echo e($product->barcode); ?></td>
                            <td><span class="badge bg-info"><?php echo e($product->category->name); ?></span></td>
                            <td><?php echo e(number_format($product->cost_price, 2)); ?> ج.م</td>
                            <td><strong><?php echo e(number_format($product->selling_price, 2)); ?> ج.م</strong></td>
                            <td>
                                <?php if($product->isLowStock()): ?>
                                    <span class="badge bg-danger"><?php echo e($product->quantity); ?></span>
                                <?php else: ?>
                                    <span class="badge bg-success"><?php echo e($product->quantity); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($product->expiry_date): ?>
                                    <?php if($product->isExpired()): ?>
                                        <span class="badge bg-danger">منتهي</span>
                                    <?php elseif($product->isExpiringSoon()): ?>
                                        <span class="badge bg-warning"><?php echo e($product->expiry_date->format('Y-m-d')); ?></span>
                                    <?php else: ?>
                                        <span class="badge bg-success"><?php echo e($product->expiry_date->format('Y-m-d')); ?></span>
                                    <?php endif; ?>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="<?php echo e(route('products.show', $product)); ?>" class="btn btn-sm btn-info btn-action">
                                    <i class="bi bi-eye"></i>
                                </a>
                                <a href="<?php echo e(route('products.edit', $product)); ?>" class="btn btn-sm btn-primary btn-action">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <form action="<?php echo e(route('products.destroy', $product)); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger btn-action"
                                            onclick="return confirm('هل أنت متأكد؟')">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9" class="text-center py-4">لا توجد منتجات</td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <?php echo e($products->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\2026\supermarket-pos\resources\views/products/index.blade.php ENDPATH**/ ?>