<?php $__env->startSection('page-title', 'تفاصيل المنتج'); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-lg-8 mx-auto">
            <div class="card">
                <div class="card-header bg-white d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="bi bi-box-seam"></i> تفاصيل المنتج</h5>
                    <div>
                        <a href="<?php echo e(route('products.edit', $product)); ?>" class="btn btn-primary btn-sm">
                            <i class="bi bi-pencil"></i> تعديل
                        </a>
                        <a href="<?php echo e(route('products.index')); ?>" class="btn btn-secondary btn-sm">
                            <i class="bi bi-arrow-right"></i> رجوع
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4 text-center mb-4">
                            <?php if($product->image): ?>
                                <img src="<?php echo e(asset('storage/' . $product->image)); ?>" class="img-fluid rounded" alt="<?php echo e($product->name); ?>">
                            <?php else: ?>
                                <div class="bg-light rounded p-5">
                                    <i class="bi bi-box-seam" style="font-size: 5rem; color: #ccc;"></i>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="col-md-8">
                            <h3><?php echo e($product->name); ?></h3>
                            <p class="text-muted"><?php echo e($product->description ?? 'لا يوجد وصف'); ?></p>

                            <table class="table table-bordered">
                                <tr>
                                    <th style="width: 40%">الباركود:</th>
                                    <td><strong><?php echo e($product->barcode); ?></strong></td>
                                </tr>
                                <tr>
                                    <th>الفئة:</th>
                                    <td><span class="badge bg-info"><?php echo e($product->category->name); ?></span></td>
                                </tr>
                                <tr>
                                    <th>الوحدة:</th>
                                    <td>
                                        <?php if($product->unit == 'piece'): ?> قطعة
                                        <?php elseif($product->unit == 'kg'): ?> كيلوجرام
                                        <?php else: ?> لتر
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th>سعر الشراء:</th>
                                    <td><?php echo e(number_format($product->cost_price, 2)); ?> ج.م</td>
                                </tr>
                                <tr>
                                    <th>سعر البيع:</th>
                                    <td class="text-success"><strong><?php echo e(number_format($product->selling_price, 2)); ?> ج.م</strong></td>
                                </tr>
                                <tr>
                                    <th>هامش الربح:</th>
                                    <td><?php echo e(number_format($product->selling_price - $product->cost_price, 2)); ?> ج.م
                                        (<?php echo e(number_format((($product->selling_price - $product->cost_price) / $product->cost_price) * 100, 1)); ?>%)
                                    </td>
                                </tr>
                                <tr>
                                    <th>الكمية المتاحة:</th>
                                    <td>
                                        <?php if($product->isLowStock()): ?>
                                            <span class="badge bg-danger fs-6"><?php echo e($product->quantity); ?></span>
                                            <small class="text-danger">(قليل!)</small>
                                        <?php else: ?>
                                            <span class="badge bg-success fs-6"><?php echo e($product->quantity); ?></span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th>الحد الأدنى:</th>
                                    <td><?php echo e($product->min_quantity); ?></td>
                                </tr>
                                <tr>
                                    <th>تاريخ الصلاحية:</th>
                                    <td>
                                        <?php if($product->expiry_date): ?>
                                            <?php if($product->isExpired()): ?>
                                                <span class="badge bg-danger"><?php echo e($product->expiry_date->format('Y-m-d')); ?> (منتهي)</span>
                                            <?php elseif($product->isExpiringSoon()): ?>
                                                <span class="badge bg-warning text-dark"><?php echo e($product->expiry_date->format('Y-m-d')); ?> (قريب)</span>
                                            <?php else: ?>
                                                <span class="badge bg-success"><?php echo e($product->expiry_date->format('Y-m-d')); ?></span>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            -
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th>تاريخ الإضافة:</th>
                                    <td><?php echo e($product->created_at->format('Y-m-d H:i')); ?></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\2025\supermarket-pos\resources\views/products/show.blade.php ENDPATH**/ ?>